/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.ars_nouveau.geckolib3.renderers.geo;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.ars_nouveau.geckolib3.compat.PatchouliCompat;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatableModel;
import software.bernie.ars_nouveau.geckolib3.core.controller.AnimationController;
import software.bernie.ars_nouveau.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.ars_nouveau.geckolib3.core.util.Color;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoBone;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoCube;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoModel;
import software.bernie.ars_nouveau.geckolib3.model.AnimatedGeoModel;
import software.bernie.ars_nouveau.geckolib3.model.provider.GeoModelProvider;
import software.bernie.ars_nouveau.geckolib3.model.provider.data.EntityModelData;
import software.bernie.ars_nouveau.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.ars_nouveau.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.ars_nouveau.geckolib3.util.AnimationUtils;
import software.bernie.ars_nouveau.geckolib3.util.EModelRenderCycle;
import software.bernie.ars_nouveau.geckolib3.util.IRenderCycle;
import software.bernie.ars_nouveau.geckolib3.util.RenderUtils;

public abstract class GeoEntityRenderer<T extends LivingEntity>
extends EntityRenderer<T>
implements IGeoRenderer<T> {
    protected final AnimatedGeoModel<T> modelProvider;
    protected final List<GeoLayerRenderer<T>> layerRenderers = Lists.newArrayList();
    protected Matrix4f dispatchedMat = new Matrix4f();
    protected Matrix4f renderEarlyMat = new Matrix4f();
    protected T animatable;
    public ItemStack mainHand;
    public ItemStack offHand;
    public ItemStack helmet;
    public ItemStack chestplate;
    public ItemStack leggings;
    public ItemStack boots;
    public MultiBufferSource rtb;
    public ResourceLocation whTexture;
    protected float widthScale = 1.0f;
    protected float heightScale = 1.0f;
    private IRenderCycle currentModelRenderCycle = EModelRenderCycle.INITIAL;

    public GeoEntityRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<T> modelProvider) {
        super(renderManager);
        this.modelProvider = modelProvider;
    }

    @Override
    @Nonnull
    @ApiStatus.AvailableSince(value="3.0.42")
    public IRenderCycle getCurrentModelRenderCycle() {
        return this.currentModelRenderCycle;
    }

    @Override
    @ApiStatus.AvailableSince(value="3.0.42")
    public void setCurrentModelRenderCycle(IRenderCycle currentModelRenderCycle) {
        this.currentModelRenderCycle = currentModelRenderCycle;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        Direction direction;
        Entity leashHolder;
        this.setCurrentModelRenderCycle(EModelRenderCycle.INITIAL);
        stack.m_85836_();
        if (entity instanceof Mob && (leashHolder = ((Mob)entity).m_21524_()) != null) {
            this.renderLeash(entity, partialTicks, stack, bufferIn, leashHolder);
        }
        this.dispatchedMat = stack.m_85850_().m_85861_().m_27658_();
        boolean shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        entityModelData.isChild = entity.m_6162_();
        float f = Mth.m_14189_((float)partialTicks, (float)((LivingEntity)entity).f_20884_, (float)((LivingEntity)entity).f_20883_);
        float f1 = Mth.m_14189_((float)partialTicks, (float)((LivingEntity)entity).f_20886_, (float)((LivingEntity)entity).f_20885_);
        float netHeadYaw = f1 - f;
        if (shouldSit && entity.m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity.m_20202_();
            f = Mth.m_14189_((float)partialTicks, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            netHeadYaw = f1 - f;
            float f3 = Mth.m_14177_((float)netHeadYaw);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            netHeadYaw = f1 - f;
        }
        float headPitch = Mth.m_14179_((float)partialTicks, (float)entity.m_146909_(), (float)entity.m_146909_());
        if (entity.m_20089_() == Pose.SLEEPING && (direction = entity.m_21259_()) != null) {
            float f4 = entity.m_20236_(Pose.STANDING) - 0.1f;
            stack.m_85837_((double)((float)(-direction.m_122429_()) * f4), 0.0, (double)((float)(-direction.m_122431_()) * f4));
        }
        float f7 = this.handleRotationFloat(entity, partialTicks);
        this.applyRotations(entity, stack, f7, f, partialTicks);
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!shouldSit && entity.m_6084_()) {
            limbSwingAmount = Mth.m_14179_((float)partialTicks, (float)((LivingEntity)entity).f_20923_, (float)((LivingEntity)entity).f_20924_);
            limbSwing = ((LivingEntity)entity).f_20925_ - ((LivingEntity)entity).f_20924_ * (1.0f - partialTicks);
            if (entity.m_6162_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        entityModelData.headPitch = -headPitch;
        entityModelData.netHeadYaw = -netHeadYaw;
        AnimationEvent<T> predicate = new AnimationEvent<T>(entity, limbSwing, limbSwingAmount, partialTicks, !(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f), Collections.singletonList(entityModelData));
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(entity));
        if (this.modelProvider instanceof IAnimatableModel) {
            this.modelProvider.setLivingAnimations(entity, this.getUniqueID(entity), (AnimationEvent)predicate);
        }
        stack.m_85837_(0.0, (double)0.01f, 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTextureLocation(entity));
        Color renderColor = this.getRenderColor(entity, partialTicks, stack, bufferIn, null, packedLightIn);
        RenderType renderType = this.getRenderType(entity, partialTicks, stack, bufferIn, null, packedLightIn, this.getTextureLocation(entity));
        if (!entity.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            VertexConsumer translucentBuffer;
            VertexConsumer glintBuffer = bufferIn.m_6299_(RenderType.m_110499_());
            this.render(model, entity, partialTicks, renderType, stack, bufferIn, glintBuffer != (translucentBuffer = bufferIn.m_6299_(RenderType.m_110470_((ResourceLocation)this.getTextureLocation(entity)))) ? VertexMultiConsumer.m_86168_((VertexConsumer)glintBuffer, (VertexConsumer)translucentBuffer) : null, packedLightIn, GeoEntityRenderer.getPackedOverlay(entity, 0.0f), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        }
        if (!entity.m_5833_()) {
            for (GeoLayerRenderer<T> layerRenderer : this.layerRenderers) {
                this.renderLayer(stack, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, partialTicks, f7, netHeadYaw, headPitch, bufferIn, layerRenderer);
            }
        }
        if (ModList.get().isLoaded("patchouli")) {
            PatchouliCompat.patchouliLoaded(stack);
        }
        stack.m_85849_();
        super.m_7392_(entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
    }

    protected void renderLayer(PoseStack stack, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float rotFloat, float netHeadYaw, float headPitch, MultiBufferSource bufferIn2, GeoLayerRenderer<T> layerRenderer) {
        layerRenderer.render(stack, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, partialTicks, rotFloat, netHeadYaw, headPitch);
    }

    @Override
    public Integer getUniqueID(T animatable) {
        return animatable.m_142081_().hashCode();
    }

    @Override
    public void renderEarly(T animatable, PoseStack stackIn, float ticks, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        this.renderEarlyMat = stackIn.m_85850_().m_85861_().m_27658_();
        this.animatable = animatable;
        this.mainHand = animatable.m_6844_(EquipmentSlot.MAINHAND);
        this.offHand = animatable.m_6844_(EquipmentSlot.OFFHAND);
        this.helmet = animatable.m_6844_(EquipmentSlot.HEAD);
        this.chestplate = animatable.m_6844_(EquipmentSlot.CHEST);
        this.leggings = animatable.m_6844_(EquipmentSlot.LEGS);
        this.boots = animatable.m_6844_(EquipmentSlot.FEET);
        this.rtb = renderTypeBuffer;
        this.whTexture = this.getTextureLocation(animatable);
        IGeoRenderer.super.renderEarly(animatable, stackIn, ticks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, partialTicks);
    }

    @Override
    public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        stack.m_85836_();
        boolean rotOverride = bone.rotMat != null;
        RenderUtils.translate(bone, stack);
        RenderUtils.moveToPivot(bone, stack);
        if (rotOverride) {
            stack.m_85850_().m_85861_().m_27644_(bone.rotMat);
            stack.m_85850_().m_85864_().m_8178_(new Matrix3f(bone.rotMat));
        } else {
            RenderUtils.rotate(bone, stack);
        }
        RenderUtils.scale(bone, stack);
        if (bone.isTrackingXform()) {
            PoseStack.Pose entry = stack.m_85850_();
            Matrix4f boneMat = entry.m_85861_().m_27658_();
            Matrix4f renderEarlyMatInvert = this.renderEarlyMat.m_27658_();
            renderEarlyMatInvert.m_27657_();
            Matrix4f modelPosBoneMat = boneMat.m_27658_();
            modelPosBoneMat.multiplyBackward(renderEarlyMatInvert);
            bone.setModelSpaceXform(modelPosBoneMat);
            Matrix4f dispatchedMatInvert = this.dispatchedMat.m_27658_();
            dispatchedMatInvert.m_27657_();
            Matrix4f localPosBoneMat = boneMat.m_27658_();
            localPosBoneMat.multiplyBackward(dispatchedMatInvert);
            Vec3 renderOffset = this.m_7860_((Entity)this.animatable, 1.0f);
            localPosBoneMat.m_27648_(new Vector3f((float)renderOffset.m_7096_(), (float)renderOffset.m_7098_(), (float)renderOffset.m_7094_()));
            bone.setLocalSpaceXform(localPosBoneMat);
            Matrix4f worldPosBoneMat = localPosBoneMat.m_27658_();
            worldPosBoneMat.m_27648_(new Vector3f((float)this.animatable.m_20185_(), (float)this.animatable.m_20186_(), (float)this.animatable.m_20189_()));
            bone.setWorldSpaceXform(worldPosBoneMat);
        }
        RenderUtils.moveBackFromPivot(bone, stack);
        if (!bone.isHidden) {
            for (GeoCube cube : bone.childCubes) {
                stack.m_85836_();
                if (!bone.cubesAreHidden()) {
                    this.renderCube(cube, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                }
                stack.m_85849_();
            }
        }
        if (!bone.childBonesAreHiddenToo()) {
            for (GeoBone childBone : bone.childBones) {
                this.renderRecursively(childBone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
        }
        stack.m_85849_();
    }

    @Override
    public GeoModelProvider<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    @Override
    @ApiStatus.AvailableSince(value="3.0.42")
    public float getWidthScale(T entity) {
        return this.widthScale;
    }

    @Override
    @ApiStatus.AvailableSince(value="3.0.42")
    public float getHeightScale(T entity) {
        return this.heightScale;
    }

    public static int getPackedOverlay(LivingEntity livingEntityIn, float uIn) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)uIn), (int)OverlayTexture.m_118096_((livingEntityIn.f_20916_ > 0 || livingEntityIn.f_20919_ > 0 ? 1 : 0) != 0));
    }

    protected void applyRotations(T entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        String s;
        Pose pose = entityLiving.m_20089_();
        if (pose != Pose.SLEEPING) {
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - rotationYaw));
        }
        if (((LivingEntity)entityLiving).f_20919_ > 0) {
            float f = ((float)((LivingEntity)entityLiving).f_20919_ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(f * this.getDeathMaxRotation(entityLiving)));
        } else if (entityLiving.m_21209_()) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f - entityLiving.m_146909_()));
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(((float)((LivingEntity)entityLiving).f_19797_ + partialTicks) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction direction = entityLiving.m_21259_();
            float f1 = direction != null ? GeoEntityRenderer.getFacingAngle(direction) : rotationYaw;
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(f1));
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(this.getDeathMaxRotation(entityLiving)));
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
        } else if ((entityLiving.m_8077_() || entityLiving instanceof Player) && ("Dinnerbone".equals(s = ChatFormatting.m_126649_((String)entityLiving.m_7755_().getString())) || "Grumm".equals(s)) && (!(entityLiving instanceof Player) || ((Player)entityLiving).m_36170_(PlayerModelPart.CAPE))) {
            matrixStackIn.m_85837_(0.0, (double)(entityLiving.m_20206_() + 0.1f), 0.0);
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        }
    }

    protected boolean isVisible(T livingEntityIn) {
        return !livingEntityIn.m_20145_();
    }

    private static float getFacingAngle(Direction facingIn) {
        switch (facingIn) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected float getDeathMaxRotation(T entityLivingBaseIn) {
        return 90.0f;
    }

    public boolean shouldShowName(T entity) {
        float f;
        double d0 = this.f_114476_.m_114471_(entity);
        float f2 = f = entity.m_20163_() ? 32.0f : 64.0f;
        if (d0 >= (double)(f * f)) {
            return false;
        }
        return entity == this.f_114476_.f_114359_ && entity.m_8077_() && Minecraft.m_91404_();
    }

    protected float getSwingProgress(T livingBase, float partialTickTime) {
        return livingBase.m_21324_(partialTickTime);
    }

    protected float handleRotationFloat(T livingBase, float partialTicks) {
        return (float)((LivingEntity)livingBase).f_19797_ + partialTicks;
    }

    @Override
    public ResourceLocation getTextureLocation(T instance) {
        return this.modelProvider.getTextureLocation(instance);
    }

    public final boolean addLayer(GeoLayerRenderer<T> layer) {
        return this.layerRenderers.add(layer);
    }

    public <E extends Entity> void renderLeash(T entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, E leashHolder) {
        int u;
        poseStack.m_85836_();
        Vec3 vec3d = leashHolder.m_7398_(partialTicks);
        double d = (double)(Mth.m_14179_((float)partialTicks, (float)((LivingEntity)entity).f_20883_, (float)((LivingEntity)entity).f_20884_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 vec3d2 = entity.m_7939_();
        double e = Math.cos(d) * vec3d2.f_82481_ + Math.sin(d) * vec3d2.f_82479_;
        double f = Math.sin(d) * vec3d2.f_82481_ - Math.cos(d) * vec3d2.f_82479_;
        double g = Mth.m_14139_((double)partialTicks, (double)((LivingEntity)entity).f_19854_, (double)entity.m_20185_()) + e;
        double h = Mth.m_14139_((double)partialTicks, (double)((LivingEntity)entity).f_19855_, (double)entity.m_20186_()) + vec3d2.f_82480_;
        double i = Mth.m_14139_((double)partialTicks, (double)((LivingEntity)entity).f_19856_, (double)entity.m_20189_()) + f;
        poseStack.m_85837_(e, vec3d2.f_82480_, f);
        float j = (float)(vec3d.f_82479_ - g);
        float k = (float)(vec3d.f_82480_ - h);
        float l = (float)(vec3d.f_82481_ - i);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        float n = Mth.m_14195_((float)(j * j + l * l)) * 0.025f / 2.0f;
        float o = l * n;
        float p = j * n;
        BlockPos blockPos = new BlockPos(entity.m_20299_(partialTicks));
        BlockPos blockPos2 = new BlockPos(leashHolder.m_20299_(partialTicks));
        int q = this.m_6086_((Entity)entity, blockPos);
        int r = leashHolder.m_6060_() ? 15 : leashHolder.f_19853_.m_45517_(LightLayer.BLOCK, blockPos2);
        int s = ((LivingEntity)entity).f_19853_.m_45517_(LightLayer.SKY, blockPos);
        int t = ((LivingEntity)entity).f_19853_.m_45517_(LightLayer.SKY, blockPos2);
        for (u = 0; u <= 24; ++u) {
            GeoEntityRenderer.renderLeashPiece(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.025f, o, p, u, false);
        }
        for (u = 24; u >= 0; --u) {
            GeoEntityRenderer.renderLeashPiece(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.0f, o, p, u, true);
        }
        poseStack.m_85849_();
    }

    private static void renderLeashPiece(VertexConsumer vertexConsumer, Matrix4f positionMatrix, float f, float g, float h, int leashedEntityBlockLight, int holdingEntityBlockLight, int leashedEntitySkyLight, int holdingEntitySkyLight, float i, float j, float k, float l, int pieceIndex, boolean isLeashKnot) {
        float m = (float)pieceIndex / 24.0f;
        int n = (int)Mth.m_14179_((float)m, (float)leashedEntityBlockLight, (float)holdingEntityBlockLight);
        int o = (int)Mth.m_14179_((float)m, (float)leashedEntitySkyLight, (float)holdingEntitySkyLight);
        int p = LightTexture.m_109885_((int)n, (int)o);
        float q = pieceIndex % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float r = 0.5f * q;
        float s = 0.4f * q;
        float t = 0.3f * q;
        float u = f * m;
        float v = g > 0.0f ? g * m * m : g - g * (1.0f - m) * (1.0f - m);
        float w = h * m;
        vertexConsumer.m_85982_(positionMatrix, u - k, v + j, w + l).m_85950_(r, s, t, 1.0f).m_85969_(p).m_5752_();
        vertexConsumer.m_85982_(positionMatrix, u + k, v + i - j, w - l).m_85950_(r, s, t, 1.0f).m_85969_(p).m_5752_();
    }

    @Override
    public void setCurrentRTB(MultiBufferSource rtb) {
        this.rtb = rtb;
    }

    @Override
    public MultiBufferSource getCurrentRTB() {
        return this.rtb;
    }

    static {
        AnimationController.addModelFetcher(object -> {
            if (object instanceof Entity) {
                return (IAnimatableModel)((Object)AnimationUtils.getGeoModelForEntity((Entity)object));
            }
            return null;
        });
    }
}

